from du3 import climb_degree
from initialize_nodes import do_stuff
from threading import Condition, Thread
import asyncio

condition_ready = Condition()
condition_stop = Condition()

graph_base = 8050
graph = {(0,1), (1, 2), (1, 3), (1, 4), (3, 4), (4, 5)}
graph = {(graph_base+x, graph_base+y) for x,y in graph}
nodes = {x for y in graph for x in y}

server_thread = Thread(target=do_stuff, args=("localhost", nodes, graph, condition_ready, condition_stop))
server_thread.start()

with condition_ready:
    condition_ready.wait()

assert(asyncio.run(climb_degree(graph_base+5)) == graph_base+1)

with condition_stop:
    condition_stop.notify()

server_thread.join()

